clear all;
close all;

% Comsol mph file (solved)
modelMech_file = strcat('experiment_compare_scale_rad_p783_num_domy_6_part2_18_2020.mph');
%modelData_file = 'v2_strip_scale_rad_p783_num_domy_6_nearK16.mat';

% Mode indices that we want to plot
Eval.mech_mode_number_min = 20;
Eval.mech_mode_number_max = 25;

%load(modelData_file);
%% load mechanical model
modelMech = mphload(modelMech_file);
fig = figure(1);
clf;
% view(0,90)
% box on
% mphgeom(modelMech)
%% plot mechanical mode

modelMech.result.create('pg2', 3);
modelMech.result('pg2').set('data', 'dset1');
modelMech.result('pg2').create('surf1', 'Surface');
modelMech.result('pg2').label('Mode Shape2 (solid)');
% modelMech.result('pg2').feature('surf1').create('def', 'Deform');
% modelMech.result('pg2').feature('surf1').feature('def').set('expr', {'u' 'v' 'w'});
% modelMech.result('pg2').feature('surf1').feature('def').set('descr', 'Displacement field (Material)');
modelMech.result('pg2').set('edges', 'off');

% Plot total energy density
modelMech.result('pg2').feature('surf1').set('expr', {'log(solid.Wh)'});
modelMech.result('pg2').feature('surf1').set('colortable', 'HeatCameraLight');
modelMech.result('pg2').feature('surf1').set('rangecoloractive', 'on');
modelMech.result('pg2').feature('surf1').set('rangecolormin', '49');
modelMech.result('pg2').feature('surf1').set('rangecolormax', '54');

% Plot disp_rms
% modelMech.result('pg2').feature('surf1').set('expr', {'solid.disp_rms'});
% modelMech.result('pg2').feature('surf1').set('colortable', 'HeatCameraLight');
% modelMech.result('pg2').feature('surf1').set('rangecoloractive', 'on');
% modelMech.result('pg2').feature('surf1').set('rangecolormin', '0');
% modelMech.result('pg2').feature('surf1').set('rangecolormax', '4');

% Plot x displacement
%modelMech.result('pg2').feature('surf1').set('expr', {'real(u)'});
%modelMech.result('pg2').feature('surf1').set('colortable', 'Wave');
%modelMech.result('pg2').feature('surf1').set('rangecoloractive', 'on');
%modelMech.result('pg2').feature('surf1').set('rangecolormin', '-4');
%modelMech.result('pg2').feature('surf1').set('rangecolormax', '4');

% Plot z displacement
% modelMech.result('pg2').feature('surf1').set('expr', {'real(w)'});
% modelMech.result('pg2').feature('surf1').set('colortable', 'Wave');
% modelMech.result('pg2').feature('surf1').set('rangecoloractive', 'on');
% modelMech.result('pg2').feature('surf1').set('rangecolormin', '-0.06');
% modelMech.result('pg2').feature('surf1').set('rangecolormax', '0.06');

% Plot divergence of displacement
% modelMech.result('pg2').feature('surf1').set('expr', {'solid.gradUxX+solid.gradUyY+solid.gradUzZ'});
% modelMech.result('pg2').feature('surf1').set('rangecolormin', '-80000');
% modelMech.result('pg2').feature('surf1').set('rangecolormax', '80000');
 
view(0,90)
box on

for i=Eval.mech_mode_number_min:Eval.mech_mode_number_max
    modelMech.result('pg2').set('looplevel', {num2str(i)});
    mphplot(modelMech, 'pg2','rangenum',1);

    view(0,90)
    box on

    % Saving .fig file
    savefig(fig, strcat('exp_compare_ene_den_k_20of30_mode_', num2str(i), '.fig'))
end
